#!/gnu/store/pwcp239kjf7lnj5i4lkdzcfcxwcfyk72-bash-minimal-5.0.16/bin/bash
# -*- wisp -*-
if ! guile -L $(dirname $(realpath "$0")) -C $(dirname $(realpath "$0")) --language=wisp -c '' 2>/dev/null; then
    guile -L $(dirname $(realpath "$0")) -C $(dirname $(realpath "$0")) -c '(import (language wisp spec))' >/dev/null 2>&1
fi
PROG="$0"
# set terminal to cbreak mode: deliver every character directly to Guile
# but as safety, first register a trap which undoes the change.
function cook () {
  # undo raw
  stty cooked
}
trap cook TERM EXIT
# direct reading which requires at least one char to read.
# keep echo for debugging
stty cbreak min 1
# stty cbreak min 1 -echo
if [[ "$1" == "-i" ]]; then
    shift
    exec -a "${PROG}" guile -L $(dirname $(realpath "$0")) -C $(dirname $(realpath "$0")) --language=wisp -x .w -e '(ypp)' -- "${@}"
else
    exec -a "${PROG}" guile -L $(dirname $(realpath "$0")) -C $(dirname $(realpath "$0")) --language=wisp -x .w -e '(ypp)' -c '' "${@}" 2>/dev/null || echo "${PROG} died" >2 && false
fi
; !#

;; for emacs (progn (defun test-this-file () (interactive) (save-buffer) (async-shell-command (concat (buffer-file-name (current-buffer)) " --test"))) (local-set-key (kbd "<f9>") 'test-this-file))

define-module : ypp
    . #:export : main

;; TODO: shot ((lambda (q) `(,q ',q)) '(lambda (q) `(,q ',q))) ;; classical
;;       and  ((λ (x) `(,(reverse x) ',x)) '(`(,(reverse x) ',x) (x) λ)) ;; Author: Tanaka Tomoyuki

import
    only (srfi srfi-19) current-date date->string string->date date->time-utc time-utc->date
                      . make-time time-utc time-duration add-duration current-time
    only (srfi srfi-9) define-record-type
    only (ice-9 pretty-print) pretty-print
    only (ice-9 format) format
    only (ice-9 futures) future ;; for an asynchronous game-loop
    only (srfi srfi-1) first second third alist-cons assoc lset<= lset-intersection lset-difference
    enter
    only (d6) roll check
    doctests

define version "0.0.0 just-do-it"

define-record-type <pose>
    pose base-x base-y inactive vulnerable striking blocking
    . pose?
    base-x pose-x
    base-y pose-y
    inactive pose-inactive
    vulnerable pose-vulnerable
    striking pose-striking
    blocking pose-blocking

define-record-type <figure>
    figure x y pose
    . figure?
    x figure-x figure-x-set!
    y figure-y figure-y-set!
    pose figure-pose figure-pose-set!
    
define : strings->pose base-x base-y drawing categorization
    ;; TODO: implement
    pose base-x base-y '() '() '() '()

define elegant-standing-0
    pose 1 0
        ' : 2 5 \
            3 4 "|"
            3 3 "|"
            2 2 /
        ' : 0 3 o
            1 2 \
            0 1 x
            0 2 x
            -1 0 /
            1 0 \
        '
        '

define elegant-standing-1
    pose 1 0
        ' : 2 4 \
            3 3 "|"
            3 2 "|"
            2 1 /
        ' : 0 3 o
            1 2 \
            0 1 x
            0 2 x
            -1 0 /
            1 0 \
        '
        '

define elegant-striking-0
    pose 1 0
        '
        ' : 0 3 o
            1 2 \
            0 1 x
            0 2 x
            -1 0 /
            1 0 \
        ' : 4 4 "|"
            4 3 /
            3 2 /
            2 2 _
        '

define elegant-striking-1
    pose 1 0
        '
        ' : 0 3 o
            1 2 \
            0 1 x
            0 2 x
            -1 0 /
            1 0 \
        ' : 5 1 /
            4 1 _
            3 1 _
            2 1 \
        '

define brace-standing-0
    pose 1 0
        ' : -2 4 /
            -2 3 3
            -2 2 \
        ' : 0 3 o
            -1 2 /
            0 1 x
            0 2 x
            -1 0 /
            1 0 \
        '
        '

define brace-standing-1
    pose 1 0
        ' : -2 4 /
            -2 3 3
            -2 2 \
        ' : 0 3 o
            -1 2 /
            0 1 x
            0 2 x
            -1 0 /
            1 0 \
        '
        '

define WIDTH 80
define HEIGHT 30

define : empty-buffer
    let loop : (s "") (rows HEIGHT) (cols WIDTH)
        cond
            : zero? rows
              . s
            : zero? cols
              loop (string-append s "\n") (- rows 1) WIDTH
            else
              loop (string-append s " ") rows (- cols 1)

define buffer : empty-buffer

define : init-buffer!
    set! buffer : empty-buffer
    display buffer

define : flip-buffer!
    ;; cursor movement: https://www.tldp.org/HOWTO/Bash-Prompt-HOWTO/x361.html
    display : string-append "\x1b[" (number->string HEIGHT) "A"
    display buffer
    set! buffer : empty-buffer

define : buffer-set! thing x y
    define line0
        * { WIDTH + 1 } { HEIGHT - 1 }
    define lineindex
        - line0 { y * { WIDTH + 1 } }
    string-set! buffer
        + x lineindex
        car : string->list : if (string? thing) thing (if (number? thing ) (number->string thing) (symbol->string thing))


define : draw-pose-elements x y px py to-draw
    let loop : : to-draw to-draw
        when : not : null? to-draw
            let 
                : dx : first : car to-draw
                  dy : second : car to-draw
                  c : third : car to-draw
                buffer-set! c
                    + x px dx
                    + y py dy
                loop : cdr to-draw

define : pose-element-positions x y px py to-draw
    let loop : (positions '()) (to-draw to-draw)
        if : null? to-draw
            . positions
            let 
                : dx : first : car to-draw
                  dy : second : car to-draw
                loop
                    cons
                        cons : + x px dx
                               + y py dy
                        . positions
                    cdr to-draw

define : show-pose x y pose
    define px : pose-x pose
    define py : pose-y pose
    draw-pose-elements x y px py : pose-inactive pose
    draw-pose-elements x y px py : pose-vulnerable pose
    draw-pose-elements x y px py : pose-striking pose
    draw-pose-elements x y px py : pose-blocking pose
            

define standing
    let : : step 0
        λ (. args)
            when : not : null? args
                set! step : car args
            show-pose
                figure-x player-figure
                figure-y player-figure
                cond
                    {step = 0} elegant-standing-0
                    {step = 1} elegant-standing-1
            set! step : modulo {step + 1} 2

define player-figure : figure 10 0 elegant-standing-0
define enemy-figure : figure 24 0 brace-standing-0

define brace
    let
        : step 0
          pos 24
          dpos 1
        λ (. args)
            when : not : null? args
                set! step : car args
            figure-pose-set! enemy-figure 
                cond
                    {step = 0} brace-standing-0
                    {step = 1} brace-standing-1
            show-pose
                figure-x enemy-figure
                figure-y enemy-figure
                figure-pose enemy-figure
            let : : pos : figure-x enemy-figure
                set! step : modulo {step + 1} 2
                when {pos < 15} : set! dpos 1
                when {pos > 30} : set! dpos -1
                figure-x-set! enemy-figure : + pos dpos


define : touches-any-xy? left right
    let loop : (l left) (r right)
        cond
            : null? r
              . #f
            : null? l
              loop left : cdr r
            : equal? (car l) (car r)
              . #t
            else
              loop (cdr l) r

define striking
    let : : step 2
        λ (. args)
            when : not : null? args
                set! step : car args
            figure-pose-set! player-figure 
                cond
                    {step = 2} elegant-striking-0
                    {step = 1} elegant-striking-1
                    else elegant-striking-1
            let*
                : striking-elements : pose-striking : figure-pose player-figure
                  striking-px : pose-x : figure-pose player-figure
                  striking-py : pose-y : figure-pose player-figure
                  player-x : figure-x player-figure
                  player-y : figure-y player-figure
                  vulnerable-elements : pose-vulnerable : figure-pose enemy-figure
                  vulnerable-px : pose-x : figure-pose enemy-figure
                  vulnerable-py : pose-y : figure-pose enemy-figure
                  enemy-x : figure-x enemy-figure
                  enemy-y : figure-y enemy-figure
                  striking : pose-element-positions player-x player-y striking-px striking-py striking-elements
                  vulnerable : pose-element-positions enemy-x enemy-y vulnerable-px vulnerable-py vulnerable-elements
                show-pose
                    figure-x player-figure
                    figure-y player-figure
                    figure-pose player-figure
                set! step : modulo {step - 1} 2
                if : touches-any-xy? striking vulnerable
                     . 'hit
                     . #f


define user-command 0
define game-over #f
define : game-loop
    let loop :
        define result #f
        brace
        cond
            : zero? user-command
              standing
            else
              set! game-over : striking user-command
              set! user-command {user-command - 1}
        flip-buffer!
        usleep 300000
        if game-over
            display "hit the any key to continue"
            loop
    
define : input-loop
    let loop :
        cond 
            : peek-char
              set! user-command 2
              let : : ch : read-char
                  if : equal? 91 : char->integer ch ;; prefix for arrows
                      let : : second-char : char->integer : read-char
                          cond
                              {second-char = 68} ;; left arrow
                                  figure-x-set! player-figure
                                      -
                                          figure-x player-figure
                                          . 1
                              {second-char = 67} ;; right arrow
                                  figure-x-set! player-figure
                                      +
                                          figure-x player-figure
                                          . 1
              ;; clear output
              ;; display "\x1b[K"
        when : not game-over
            loop

define : game
    init-buffer!
    setvbuf (current-input-port) 'none
    future : game-loop
    input-loop
    over

define : over
    Enter : Ypp
    if : equal? game-over 'hit
        Ypp
            You won!
            You returned 
            the eternal flame 
            to its glory.
            Congratulations!
        Ypp
            You lost. Try again.

define : intro
    Enter : Ypp
    Ypp
        "   _   "
        "  / \\  " Your parents
        " |* *| " parentheses
        "  \\-/  "
        "       "
        " ((((( " Weapons
        " ((((( " from a
        "|-- --|" more civilized
        " |   | " age
        " |   | "
        " |   | "
        

define : menu
    Choose
        : start game
          ,(game)
    

define : epilog
    Enter : Ypp
    Ypp
        Created by Arne Babenhauserheide
        Made with Guile
        Made with Wisp
        Have fun!


define : main args
         intro
         menu
